This document describes the syntax of the Bones micro-language, which is used in the `.order` property in Bonnie configurations. This page won't give full Bonnie configuration examples, but just examples that can be put into `.order` in the Bones language. If you need a refresher on the basics of ordered subcommands, see [this page](./Getting-Started-with-Bones).

This document will use `first`, `second`, `third` etc. and assume that are all valid subcommands.

## Basic Syntax

The most simple Bones syntax possible is just to call a single subcommand like so:

```
first
```

This will run `first` and terminate with its exit code, and that's where the first piece of understanding comes in. In Bones, **every command is represents the promise of an exit code**. In other words, Bones doesn't care about what the command does or outputs, it just cares about the exit code. That allows us to control what happens based on the success/failure of commands. In the case of the simple syntax above, Bones doesn't care what the exit code is, it will just return it.

This simple syntax is detected automatically and the full parsing process is avoided to speed things up.

The Bonnie response will exit with the exit code of the last command to run, always (this goes beyond ordered subcommands as well).

## Complex Syntax

Full Bones syntax looks something like this:

```
first {
	Success => second,
	Failure => third {
		Success => first {
			Success => second
		}
	}
}
```

This demonstrates the fullness of Bones syntax quite well. Here's a more manageable outline of what this will actually do in pseudocode:

```
if first == Success {
	return second
} else {
	if third == Success {
		if first == Success {
			return second
		}
	}
}
```

Hopefully you can see now that this is essentially a recovery flow. If the first command succeeds, we go on to the second command. If not, we try to recover by running the third command, and then we try again. If that works now, we go to the second command. If not, we abort. In the real world, `first` might build a server and `second` might run it. If the build fails, we run `third` to get a fresh copy of the code adn we can try again.

This kind of expression makes Bones extremely powerful, while simultaneously being very expressive and natural to understand once you get the hang of it.

Bones syntax can be expressed more generally like so:

```
COMMAND {
	OPERATOR => COMMAND [recurse],
	...
}
```

Essentially, Bones calls commands and then uses operators to see if they match certain conditions, and then it takes further action accordingly. If no operator matches, the flow will abort and the last exit code will be returned by the Bonnie program. Operators are discussed in detail [here](./Operators).

## Stability

Please note that Bones is a novel concept and very new. Though tested extensively, bugs are likely to pop up in certain edge cases, so please [open an issue](https://github.com/arctic-hen7/bonnie/issues/new/choose) is you find a bug! We'll get to fixing it as soon as possible to make Bones better for everyone!
